@extends('layouts.master')
@section('title',__('All Blogs'))
@section('breadcum')
  <div class="breadcrumbbar">
      <h4 class="page-title">{{ __('All Blogs') }}</h4>
      <div class="breadcrumb-list">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ __('Blogs') }}</li>
          </ol>
      </div>  
  </div>
@endsection
@section('maincontent')
<div class="contentbar permissionTable"> 
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header movie-create-heading">
          <div class="row">
            <div class="col-lg-4 col-4 col-md-4">
              <h5 class="card-title">{{ __('All Blogs') }}
                   <input class="grand_selectallm ml-3" type="checkbox" id="select-all">
                   {{__('Select All') }}
              </h5>
            </div>
            <div class="col-lg-8 col-8 col-md-8">
              @can('movies.delete')
  <button type="button" 
          class="float-right btn btn-danger-rgba mr-2" 
          data-toggle="modal" 
          data-target="#bulk_delete"
          onclick="return checkSelectedItems()"
          title="{{ __('Delete Selected') }}">
    <i class="feather icon-trash mr-2"></i> {{ __('Delete Selected') }}
  </button>
@endcan
              @can('movies.create')
              <a href="{{route('blog.create')}}" class="float-right btn btn-primary-rgba mr-2" title="{{ __('Add Post') }}">
                <i class="feather icon-plus mr-2"></i>{{ __('Add Post') }}
              </a>
              @endcan
            </div>
          </div>
        </div>
        <div class="card-body">
            <section id="movies" class="movies-main-block blog-admin-page">
                <div class="row">
                  @foreach($blogs as $item) 
                    <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                        <input class="permissioncheckbox form-check-card-input visibility-visible" 
                               type="checkbox" 
                               value="{{ $item->id }}" 
                               id="checkbox{{ $item->id }}" 
                               name="checked[]">         
                        <div class="card">
                          @if($item->image != NULL)
                          <a href="{{url('account/blog/', $item->slug)}}" target="_blank" title="{{$item->title}}">
                            <img src="{{url('/images/blog/' . $item->image)}}" class="card-img-top" alt="{{$item->title}}">
                          </a>
                          @else
                          <a href="{{url('account/blog/', $item->slug)}}" target="_blank" title="{{$item->title}}">
                            <img src="{{Avatar::create($item->title)->toBase64()}}" class="card-img-top" alt="{{$item->title}}">
                          </a>
                          @endif
                            <div class="overlay-bg"></div>
                            <div class="dropdown card-dropdown">
                                <a class="btn btn-round btn-outline-primary pull-right dropdown-toggle" 
                                   type="button" 
                                   id="dropdownMenuButton-{{ $item->id }}" 
                                   data-toggle="dropdown" 
                                   aria-haspopup="true" 
                                   aria-expanded="false" 
                                   title="{{__('Settings')}}">
                                   <i class="feather icon-more-vertical-"></i>
                                </a>
                                <div class="dropdown-menu pull-right" aria-labelledby="dropdownMenuButton-{{ $item->id }}">
                                  @can('blog.view')
                                    <a class="dropdown-item" href="{{url('account/blog/', $item->slug)}}" target="_blank" title="{{__('View')}}">
                                      <i class="feather icon-monitor mr-2"></i> {{__('View')}}
                                    </a>     
                                  @endcan
                                  @can('blog.edit')                                   
                                    <a class="dropdown-item" href="{{ route('blog.edit', $item->id)}}" title="{{__('Edit')}}">
                                      <i class="feather icon-edit mr-2"></i> {{__('Edit')}}
                                    </a>    
                                  @endcan
                                  @can('blog.delete')                                  
                                    <a type="button" class="dropdown-item" data-toggle="modal" data-target="#deleteModal{{ $item->id }}" title="{{__('Delete')}}">
                                      <i class="feather icon-trash mr-2"></i> {{__('Delete')}}
                                    </a>
                                  @endcan
                                </div>
                            </div>
                            <div class="card-header">
                              <h5 class="card-title">
                                <a href="{{url('account/blog/', $item->slug)}}" target="_blank" title="{{$item->title}}">
                                  {{$item->title}}
                                </a>
                              </h5>
                            </div>
                            <div class="card-body">                                    
                                <div class="card-block">
                                    <h6 class="card-body-sub-heading">{{__('Description')}}</h6>
                                    {{ $item->detail ? \Illuminate\Support\Str::words($item->detail, 10, '...') : '-' }}
                                </div>
                                <div class="card-block row">
                                    <div class="col-xs-6 col-md-6 col-md-6">
                                        <h6 class="card-body-sub-heading">{{__('Status')}}</h6>
                                        <p class="status-btn">
                                          @if($item->is_active == 1)
                                            <span>{{__('Active')}}</span>
                                          @else
                                            <span>{{__('De Active')}}</span>
                                          @endif
                                        </p>
                                   </div>
                                </div>              
                            </div>
                        </div>
                    </div>
                    @endforeach
                    <div class="col-md-12 pagination-block text-center">
                      {!! $blogs->appends(request()->query())->links() !!}
                    </div>
                </div>
            </section>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Individual Delete Modals -->
@foreach($blogs as $item) 
<div id="deleteModal{{ $item->id }}" class="delete-modal modal fade card-dropdown-modal" role="dialog">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">×</button>
                <div class="delete-icon"></div>
            </div>
            <div class="modal-body text-center">
                <h4 class="modal-heading">{{__('Are You Sure ?')}}</h4>
                <p>{{__('Do you really want to delete this record? This process cannot be undone.')}}</p>
            </div>
            <div class="modal-footer">
              <form method="POST" action="{{ route('blog.destroy', $item->id) }}">
                    @csrf
                    @method('DELETE')
                    <button type="button" class="btn btn-secondary translate-y-3" data-dismiss="modal">{{__('No')}}</button>
                    <button type="submit" class="btn btn-primary">{{__('Yes')}}</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endforeach
<!-- Bulk Delete Modal -->
<div id="bulk_delete" class="delete-modal modal fade" role="dialog">
  <div class="modal-dialog modal-sm">
      <div class="modal-content">
          <div class="modal-header">
              <button type="button" class="close" data-dismiss="modal" title="{{ __('Close') }}">&times;</button>
              <div class="delete-icon"></div>
          </div>
          <div class="modal-body text-center">
              <h4 class="modal-heading">{{__('Are You Sure ?')}}</h4>
              <p>{{__('Do you really want to delete the selected items? This process cannot be undone.')}}</p>
          </div>
          <div class="modal-footer">
              <button type="button" class="btn btn-secondary translate-y-3" data-dismiss="modal">{{__('No')}}</button>
              <button type="button" class="btn btn-primary" onclick="confirmBulkDelete()">{{__('Yes')}}</button>
          </div>
      </div>
  </div>
</div>
<!-- Hidden form for bulk delete -->
<form method="POST" action="{{ url('/admin/blog/bulk_delete') }}" id="bulk_delete_form" style="display: none;">
    @csrf
</form>
@endsection 
@section('script')
<script>
$(document).ready(function() {
    // Select all checkbox functionality
    $('#select-all').change(function() {
        $('.permissioncheckbox').prop('checked', this.checked);
    });
    
    // Individual checkbox change
    $('.permissioncheckbox').change(function() {
        if (!this.checked) {
            $('#select-all').prop('checked', false);
        } else {
            if ($('.permissioncheckbox:checked').length === $('.permissioncheckbox').length) {
                $('#select-all').prop('checked', true);
            }
        }
    });
});

function openBulkDeleteModal() {
    // Check if any checkboxes are selected
    var checkedBoxes = $('.permissioncheckbox:checked');
    console.log('Checked boxes count:', checkedBoxes.length); // Debug line
    
    if (checkedBoxes.length === 0) {
        alert('{{__("Please select at least one item to delete")}}');
        return false;
    }
    
    // Show the modal
    $('#bulk_delete').modal('show');
    return true;
}

function confirmBulkDelete() {
    var form = document.getElementById('bulk_delete_form');
    
    // Clear existing hidden inputs
    var existingInputs = form.querySelectorAll('input[name="checked[]"]');
    existingInputs.forEach(function(input) {
        input.remove();
    });
    
    // Add selected checkboxes as hidden inputs
    var checkedCount = 0;
    $('.permissioncheckbox:checked').each(function() {
        var input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'checked[]';
        input.value = this.value;
        form.appendChild(input);
        checkedCount++;
    });
    
    console.log('Adding', checkedCount, 'items to delete'); // Debug line
    
    // Close modal and submit form
    $('#bulk_delete').modal('hide');
    
    // Small delay to ensure modal is closed before form submission
    setTimeout(function() {
        form.submit();
    }, 300);
}
</script>
@endsection